// Scilab Version: 6.0.1
//O.S : Windows 10
//Caption: Convolution integral of x(t)=(e^-at).u(t) and h(t)=u(t)
clear;
close;
clc;
T=10;
h=ones(1,T);
N2=0:length(h)-1;
a=0.5;
for t=1:T
    x(t)=exp(-a*(t-1));
end
N1=0:length(x)-1;
y=conv(x,h)-1;
N=0:length(x)+length(h)-2;
subplot(2,3,1);
plot(N1,x)
xlabel("t");
ylabel("Amplitude");
xgrid(4,1,7);
title("Input signal x(t)=(e^-at).u(t)")
subplot(2,3,2);
plot(N2,h);
xlabel("t");
ylabel("Amplitude");
xgrid(4,1,7);
title("Input signal h(t)=u(t)");
subplot(2,3,3);
plot(N(1:T),y(1:T))
xlabel("t");
ylabel("Amplitude");
title("Convolution Integral y(t)=x(t) h(t)");
xgrid(4,1,7);
